using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace MultipleResultset_SP_NextRecordset
{
    /// <summary>
    /// Summary description for Form1.
    /// </summary>
    public class Form1 : System.Windows.Forms.Form
    {
        private SqlConnection cn;
        private SqlCommand sc;

        internal System.Windows.Forms.Label lblRows;
        internal System.Windows.Forms.TextBox txtTitleWanted;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.Button btnFind;
        /// <summary>
        /// Required designer variable.
        /// </summary>
        private System.ComponentModel.Container components = null;

        public Form1()
        {
            try
            {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();
           
 
                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                
                // Create a connection object  
                cn = new SqlConnection("data source=.;database=biblio;uid=admin;pwd=pw");
                
                // Create a (stored procedure) SqlCommand, Add (and configure) the Parameters
                sc = new SqlCommand("MultipleResultsetRowsetAction",cn);
                sc.CommandType = CommandType.StoredProcedure;

                sc.Parameters.Add("@ReturnValue", SqlDbType.Int);  
                sc.Parameters.Add("@TitleWanted", SqlDbType.VarChar, 20); 
                sc.Parameters["@ReturnValue"].Direction = ParameterDirection.ReturnValue;

            }
            catch(Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
			
        }

        /// <summary>
        /// Clean up any resources being used.
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if (components != null) 
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

		#region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.lblRows = new System.Windows.Forms.Label();
            this.txtTitleWanted = new System.Windows.Forms.TextBox();
            this.Label1 = new System.Windows.Forms.Label();
            this.btnFind = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // lblRows
            // 
            this.lblRows.Location = new System.Drawing.Point(304, 56);
            this.lblRows.Name = "lblRows";
            this.lblRows.Size = new System.Drawing.Size(104, 24);
            this.lblRows.TabIndex = 8;
            // 
            // txtTitleWanted
            // 
            this.txtTitleWanted.Location = new System.Drawing.Point(184, 8);
            this.txtTitleWanted.Name = "txtTitleWanted";
            this.txtTitleWanted.Size = new System.Drawing.Size(304, 20);
            this.txtTitleWanted.TabIndex = 7;
            this.txtTitleWanted.Text = "Hi%";
            // 
            // Label1
            // 
            this.Label1.Location = new System.Drawing.Point(0, 8);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(160, 24);
            this.Label1.TabIndex = 6;
            this.Label1.Text = "Title wanted (with %)";
            this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // btnFind
            // 
            this.btnFind.Location = new System.Drawing.Point(184, 56);
            this.btnFind.Name = "btnFind";
            this.btnFind.Size = new System.Drawing.Size(72, 32);
            this.btnFind.TabIndex = 5;
            this.btnFind.Text = "Find";
            this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(496, 125);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.lblRows,
                                                                          this.txtTitleWanted,
                                                                          this.Label1,
                                                                          this.btnFind});
            this.Name = "Form1";
            this.Text = "Form1";
            this.ResumeLayout(false);

        }
		#endregion

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main() 
        {
            Application.Run(new Form1());
        }

        private void btnFind_Click(object sender, System.EventArgs e)
        {
            try
            {
                // Declare a DataReader
                SqlDataReader dr;
            
                // Open the connection, set the Select procedure parameter and
                // Execute the Reader (the DataReader that is not you - I hope!)
                cn.Open();
                sc.Parameters["@TitleWanted"].Value = txtTitleWanted.Text;
                dr = sc.ExecuteReader();
                
                // Loop while there is another resultset in the DataReader
                
                while (dr.NextResult())
                {
                    Debug.WriteLine("Records affected = " + dr.RecordsAffected);
                    if (dr.FieldCount > 0)
                    {
                        ShowRows(dr);
                    }
                    else
                    {
                        Debug.WriteLine("No rowset in this result set");
                    }
                }
            
                // Close the reader so that we can get to the ReturnValue
                dr.Close();

                // Copy the ReturnValue to a form label control
                lblRows.Text = sc.Parameters["@ReturnValue"].Value.ToString();
            }
            catch (Exception ex )
            {
                Debug.WriteLine(ex.ToString());
            }
            finally
            {
                // WE MUST CLOSE THE CONNECTION.
                cn.Close();
            }
        }

        private void ShowRows(SqlDataReader pDr)
        {
            try
            {
                // Loop through the DataReader and dump the Fields to the Debug Device.
                while (pDr.Read())
                {
                    for( int i = 0; i < pDr.FieldCount - 1; i++)
                    {
                        Console.Write(pDr.GetName(i) + " - ");
                        Console.Write("  DataTypeName=" + pDr.GetDataTypeName(i));
                        Console.WriteLine(" = " + pDr.GetValue(i));
                    }
                }
                Console.WriteLine("______________");
            }
            catch(Exception ex)
            {
                Debug.WriteLine(ex.ToString());
            }
        }
    }
}